/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.snippets.ui.views;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.ExtendedFastPartitioner;
import com.aptana.editor.common.IExtendedPartitioner;
import com.aptana.editor.common.IPartitionerSwitchStrategy;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.NullPartitionerSwitchStrategy;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.scripting.snippets.SnippetTemplateUtil;
import com.aptana.editor.common.text.rules.CompositePartitionScanner;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.NullSubPartitionScanner;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.formatter.IScriptFormatterFactory;
import com.aptana.formatter.ScriptFormatterManager;
import com.aptana.formatter.preferences.profile.ProfileManager;
import com.aptana.formatter.ui.preferences.FormatterPreviewUtils;
import com.aptana.formatter.ui.preferences.ScriptSourcePreviewerUpdater;
import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.BundlePrecedence;
import com.aptana.scripting.model.SnippetElement;
import com.aptana.scripting.model.TriggerType;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.snippets.ui.views.Messages;
import com.aptana.theme.ColorManager;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import com.aptana.ui.util.UIUtils;
import com.aptana.workbench.commands.EditBundleJob;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public class SnippetPopupDialog
extends PopupDialog {
    private static final String SNIPPETS_POPUP_SETTINGS = "snippets.popup.settings";
    private ToolBar toolbar;
    private Control positionTarget;
    private List<Image> toolbarImages = new ArrayList<Image>();
    private SnippetElement snippet;
    private ColorManager colorManager;
    private Point popupSize = null;
    private String tabChar;
    private static final int POPUP_OFFSET = 3;
    public static final int PROPOSAL_INSERT = 1;
    private QualifiedContentType translatedQualifiedType;
    private Composite toolbarComp;
    private ISourceViewer snippetViewer;
    private Composite mainComp;
    private Composite snippetComp;

    public SnippetPopupDialog(Shell shell, SnippetElement snippet, Control positionTarget) {
        super(shell, 4, true, true, false, false, false, snippet.getDisplayName(), null);
        this.positionTarget = positionTarget;
        this.snippet = snippet;
        this.colorManager = new ColorManager();
        this.tabChar = Platform.getOS().equals("macosx") ? "\u21e5" : "\u00bb";
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        return super.createContents(composite);
    }

    protected Control createDialogArea(Composite parent) {
        this.mainComp = (Composite)super.createDialogArea(parent);
        this.snippetComp = new Composite(this.mainComp, 0);
        this.snippetComp.setLayout((Layout)new FillLayout());
        this.snippetComp.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.snippetViewer = this.createSnippetViewer(this.snippetComp);
        Label separator = new Label(this.mainComp, 258);
        separator.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.toolbarComp = new Composite(this.mainComp, 0);
        this.toolbarComp.setBackground(null);
        this.toolbarComp.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(2, 2).create());
        this.toolbarComp.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.toolbar = new ToolBar(this.toolbarComp, 256);
        this.toolbar.setBackground(null);
        this.toolbar.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        ToolItem openSnippetItem = new ToolItem(this.toolbar, 8);
        Image navigateImage = ScriptingUIPlugin.getImageDescriptor((String)"/icons/full/elcl16/nav_snippet_tsk.png").createImage();
        this.toolbarImages.add(navigateImage);
        openSnippetItem.setImage(navigateImage);
        openSnippetItem.setToolTipText(Messages.SnippetPopupDialog_Open_Snippet_Source_desc);
        openSnippetItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final BundleElement bundle = SnippetPopupDialog.this.snippet.getOwningBundle();
                BundlePrecedence bundlePrecedence = bundle.getBundlePrecedence();
                if (bundlePrecedence != BundlePrecedence.PROJECT && bundlePrecedence != BundlePrecedence.USER) {
                    EditBundleJob job = new EditBundleJob(bundle);
                    job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            this.openBundleSnippet(bundle);
                        }
                    });
                    job.schedule();
                } else {
                    this.openBundleSnippet(bundle);
                }
                SnippetPopupDialog.this.close();
            }

            private void openBundleSnippet(BundleElement bundle) {
                String path = SnippetPopupDialog.this.snippet.getPath();
                List bundleSnippets = BundleManager.getInstance().getBundleSnippets(bundle.getDisplayName());
                for (SnippetElement element : bundleSnippets) {
                    if (!element.getDisplayName().equals(SnippetPopupDialog.this.snippet.getDisplayName()) || !element.getExpansion().equals(SnippetPopupDialog.this.snippet.getExpansion())) continue;
                    path = element.getPath();
                    break;
                }
                final File file = new File(path);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        Object[] foundFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(file.toURI());
                        if (!ArrayUtil.isEmpty((Object[])foundFiles)) {
                            EditorUtil.openInEditor((File)new File(foundFiles[0].getLocationURI()));
                        } else if (file.exists()) {
                            EditorUtil.openInEditor((File)file);
                        }
                    }
                });
            }
        });
        return this.mainComp;
    }

    protected Control createTitleControl(Composite parent) {
        Control control = super.createTitleControl(parent);
        Label subText = new Label(parent, 64);
        String[] prefixes = this.snippet.getTriggerTypeValues(TriggerType.PREFIX);
        String[] formattedPrefixes = new String[prefixes.length];
        int i = 0;
        while (i < formattedPrefixes.length) {
            formattedPrefixes[i] = MessageFormat.format("{0}{1}", prefixes[i], this.tabChar);
            ++i;
        }
        String scopeString = this.snippet.getScope();
        if (scopeString == null) {
            scopeString = Messages.SnippetPopupDialog_Scope_None;
        }
        subText.setText(MessageFormat.format(Messages.SnippetPopupDialog_Desciption, scopeString, StringUtil.join((String)",", (String[])formattedPrefixes)));
        subText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        return control;
    }

    private ColorManager getColorManager() {
        return ThemePlugin.getDefault().getColorManager();
    }

    private Theme getCurrentTheme() {
        return ThemePlugin.getDefault().getThemeManager().getCurrentTheme();
    }

    protected Color getBackground() {
        return this.getColorManager().getColor(this.getCurrentTheme().getBackground());
    }

    protected Color getForeground() {
        return this.getColorManager().getColor(this.getCurrentTheme().getForeground());
    }

    protected List getBackgroundColorExclusions() {
        List exclusions = super.getBackgroundColorExclusions();
        exclusions.add(this.toolbar);
        exclusions.add(this.toolbarComp);
        exclusions.add(this.mainComp);
        exclusions.add(this.snippetComp);
        return exclusions;
    }

    private ISourceViewer createSnippetViewer(Composite parent) {
        ProjectionViewer viewer = new ProjectionViewer(parent, null, null, false, 768);
        StyledText styledText = viewer.getTextWidget();
        styledText.setFont(JFaceResources.getTextFont());
        IScriptFormatterFactory factory = null;
        String contentType = this.getContentType();
        if (contentType != null) {
            factory = ScriptFormatterManager.getSelected((String)contentType);
        }
        IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
        if (factory != null) {
            ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{factory.getPreferenceStore(), generalTextStore});
            SourceViewerConfiguration configuration = factory.createSimpleSourceViewerConfiguration((ISharedTextColors)this.colorManager, (IPreferenceStore)store, null, false);
            viewer.configure(configuration);
            new ScriptSourcePreviewerUpdater((SourceViewer)viewer, configuration, (IPreferenceStore)store);
        }
        if (viewer.getTextWidget().getTabs() == 0) {
            viewer.getTextWidget().setTabs(4);
        }
        viewer.getTextWidget().setEnabled(false);
        viewer.setEditable(false);
        Document document = new Document();
        viewer.setDocument((IDocument)document);
        String expansion = this.snippet.getExpansion();
        if (expansion != null) {
            expansion = SnippetTemplateUtil.evaluateSnippet((SnippetElement)this.snippet, (IDocument)document, (Position)new Position(0));
        }
        if (factory != null) {
            IPartitioningConfiguration partitioningConfiguration = (IPartitioningConfiguration)factory.getPartitioningConfiguration();
            CompositePartitionScanner partitionScanner = new CompositePartitionScanner(partitioningConfiguration.createSubPartitionScanner(), (ISubPartitionScanner)new NullSubPartitionScanner(), (IPartitionerSwitchStrategy)new NullPartitionerSwitchStrategy());
            ExtendedFastPartitioner partitioner = new ExtendedFastPartitioner((IPartitionTokenScanner)partitionScanner, partitioningConfiguration.getContentTypes());
            partitionScanner.setPartitioner((IExtendedPartitioner)partitioner);
            partitioner.connect((IDocument)document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
            ProfileManager manager = ProfileManager.getInstance();
            IResource selectedResource = UIUtils.getSelectedResource();
            IProject project = null;
            if (selectedResource == null) {
                IEditorPart activeEditor = UIUtils.getActiveEditor();
                if (activeEditor instanceof AbstractThemeableEditor) {
                    project = EditorUtil.getProject((AbstractThemeableEditor)((AbstractThemeableEditor)activeEditor));
                }
            } else {
                project = selectedResource.getProject();
            }
            if (project != null) {
                FormatterPreviewUtils.updatePreview((ISourceViewer)viewer, (String)expansion, null, (IScriptFormatterFactory)factory, (Map)manager.getSelected(project).getSettings());
            } else {
                document.set(expansion);
            }
        } else {
            document.set(expansion);
        }
        if (this.translatedQualifiedType != null) {
            String[] stringArray = this.translatedQualifiedType.getParts();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                viewer.removeTextHovers(part);
                ++n2;
            }
        }
        return viewer;
    }

    private String getContentType() {
        AbstractThemeableEditor abstractThemeableEditor;
        ISourceViewer sourceViewer;
        IEditorPart activeEditor = UIUtils.getActiveEditor();
        if (activeEditor instanceof AbstractThemeableEditor && (sourceViewer = (abstractThemeableEditor = (AbstractThemeableEditor)activeEditor).getISourceViewer()) != null) {
            IDocument document = sourceViewer.getDocument();
            int caretOffset = abstractThemeableEditor.getCaretOffset();
            try {
                this.translatedQualifiedType = CommonEditorPlugin.getDefault().getDocumentScopeManager().getContentType(document, caretOffset);
                if (this.translatedQualifiedType != null) {
                    return this.extractContentType(this.translatedQualifiedType);
                }
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)ScriptingUIPlugin.getDefault(), (String)MessageFormat.format("Caret offset {0} was out of bounds with a max of {1} for {2}", caretOffset, document.get().length(), abstractThemeableEditor.getPartName()), (String)"com.aptana.editor.common/debug/presentation");
            }
        }
        return null;
    }

    protected String extractContentType(QualifiedContentType qualifiedContentType) {
        if (qualifiedContentType == null) {
            return null;
        }
        int partCount = qualifiedContentType.getPartCount();
        if (partCount > 2) {
            return qualifiedContentType.getParts()[partCount - 2];
        }
        return qualifiedContentType.getParts()[0];
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings dialogSettings = ScriptingUIPlugin.getDefault().getDialogSettings();
        if (dialogSettings != null) {
            IDialogSettings section = dialogSettings.getSection(SNIPPETS_POPUP_SETTINGS);
            if (section == null) {
                section = dialogSettings.addNewSection(SNIPPETS_POPUP_SETTINGS);
            }
            return section;
        }
        return null;
    }

    public boolean close() {
        boolean willClose = super.close();
        if (willClose) {
            for (Image image : this.toolbarImages) {
                image.dispose();
            }
            this.colorManager.dispose();
        }
        return willClose;
    }

    protected void adjustBounds() {
        Point location = this.positionTarget.getDisplay().map((Control)this.positionTarget.getParent(), null, this.positionTarget.getLocation());
        Point targetSize = this.positionTarget.getSize();
        Point sizeSize = UIUtils.getActiveWorkbenchWindow().getShell().getSize();
        int initialX = location.x + targetSize.x;
        int initialY = location.y + 3;
        if (this.popupSize == null) {
            this.getShell().pack();
            this.popupSize = this.getShell().getSize();
            if (this.popupSize.x > 500) {
                this.popupSize.x = 500;
            }
            if (this.popupSize.y > sizeSize.y) {
                this.popupSize.y = sizeSize.y;
            }
            if ("macosx".equals(Platform.getOS())) {
                ScrollBar verticalBar;
                ScrollBar horizontalBar = this.snippetViewer.getTextWidget().getHorizontalBar();
                if (horizontalBar != null) {
                    int height = horizontalBar.getSize().y;
                    this.popupSize.y += height;
                }
                if ((verticalBar = this.snippetViewer.getTextWidget().getVerticalBar()) != null) {
                    int width = verticalBar.getSize().x;
                    this.popupSize.x += width;
                }
            }
        }
        Rectangle constrainedBounds = this.getConstrainedShellBounds(new Rectangle(initialX, initialY, this.popupSize.x, this.popupSize.y));
        if (constrainedBounds.y < initialY) {
            this.getShell().setBounds(initialX, location.y - this.popupSize.y, this.popupSize.x, this.popupSize.y);
        } else {
            this.getShell().setBounds(initialX, initialY, this.popupSize.x, this.popupSize.y);
        }
    }

    protected Control getFocusControl() {
        this.snippetViewer.getTextWidget().setEnabled(true);
        return this.getContents();
    }
}

